/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rxfunctions.h"
#include "global.h"
#include "configparams.h"
#include "soundio.h"
#include "dispatcher.h"
#include "syncprocessor.h"
#include "filter.h"
#include "filterparam.h"
#include "modes/modes.h"
#include "rxwidget.h"



#ifndef QT_NO_DEBUG
#include "scopeview.h"
#endif

//#define FILTERDELAY (RXNUMTAPS-23)
#define FILTERDELAY (-10)
//#define RXFUNSCOPE_ENABLED

unsigned int modeComboBoxIndexSSTV;
efaxMode modeIndexFAX;
bool selectFax;

const QString stateStr[rxFunction::WAIT+1]=
{
	"Hunting",
	"Processing",
	"Restart",
	"Sync Lost",
	"End",
	"Wait"
};



rxFunction::rxFunction()
{
	syncProc=new syncProcessor(RXSTRIPE);
  rxFilter= NULL;
	currentMode=0;
  bufferCount=0;
  setState(HUNTING);
}

rxFunction::~rxFunction()
{
	delete syncProc;
	delete rxFilter;
	if(currentMode) delete currentMode;
}

void rxFunction::run()
{
	int count;
	bool done;
	abortRun=FALSE;
	init();
  bufferCount=0;
	while(!abortRun)
		{
			if((count=sndIO->rxBuffer.count())<RXSTRIPE)
				{
				 	msleep((250*RXSTRIPE)/rxClock);
//					addToLog("rxfunction sleeping",DBRXFUNC);
					continue;
				}
			else
				{
          bufferCount++;
					sndIO->rxBuffer.copy(tempBuf,RXSTRIPE);
					sndIO->rxBuffer.skip(RXSTRIPE);
					displayFFTEvent* ce = new displayFFTEvent(tempBuf);
					ce->waitFor(&done);
					QApplication::postEvent(dispatchPtr, ce);
					 while(!done) { usleep(10);}
					switch(rxMode)
						{
							case SSTV: runSSTV(); break;
							case FAX: runFAX(); break;
						}
				}
		}
	addToLog("rx function aborted",DBRXMAIN);
}

void rxFunction::getData()
{
  rxFilter->processFM(tempBuf);
  syncProc->process(tempBuf);
#ifndef QT_NO_DEBUG
#ifdef RXFUNSCOPE_ENABLED
  scopeViewer->addData1(rxFilter->filteredDataPtr(),sampleCounter,RXSTRIPE);
  scopeViewer->addData3(syncProc->getSyncBufferPtr(),sampleCounter,RXSTRIPE);
#endif
#endif
}

void rxFunction::runSSTV()
{
  int block;
  bool done;
  unsigned int insync;
	unsigned long sampleCounterLatch;
	endImageRXEvent* ce;

	switch(rxState)
		{
			case HUNTING:
				{
        getData();
				sampleCounter+=RXSTRIPE;
        if((insync=syncProc->isInSync())==0)	break; // no sync
        if(!create(syncProc->getMode(),syncProc->getNewClock())) break;
				statusMsgEvent *stce= new statusMsgEvent(QString("Found: ")+getSSTVModeNameLong(syncProc->getMode()));
				lastUsedMode=getSSTVModeNameShort(syncProc->getMode());
				QApplication::postEvent( dispatchPtr, stce );  // Qt will delete it when done
				syncPosition=syncProc->getSyncPosition();
        if(insync==1)
        {
          syncPosition=currentMode->adjustSyncPosition(syncPosition); // only execute if no retrace
          addToLog(QString("rxFunctions: adjusted syncPosition= %1").arg(syncPosition),DBRXFUNC);
        }
				sampleCounterLatch=sampleCounter; //remember where we've got
        addToLog(QString("rxFunctions: sampleCounterLatch= %1").arg(sampleCounterLatch),DBRXFUNC);
				block=(syncPosition+FILTERDELAY)/RXSTRIPE;
				sndIO->rxBuffer.rewind(sampleCounter-block*RXSTRIPE+RXSTRIPE); // do not combine into -(block-1)*RXSTRIPE in case block=0

				addToLog(QString("sc_rewind: block=%1,rewind= %2").arg(block).arg(sampleCounter-block*RXSTRIPE+RXSTRIPE),DBRXFUNC);
				sndIO->rxBuffer.copy(tempBuf,RXSTRIPE); //dummy run to setup filter
				rxFilter->processFM(tempBuf);
				sndIO->rxBuffer.skip(RXSTRIPE);
				sampleCounter=(block)*RXSTRIPE;

				sndIO->rxBuffer.copy(tempBuf,RXSTRIPE);

				rxFilter->processFM(tempBuf);
				currentMode->redrawFast(TRUE);
        currentMode->setRxSampleCounter(sampleCounter);

        currentMode->process(rxFilter->filteredDataPtr(),syncPosition-(block)*RXSTRIPE+FILTERDELAY,TRUE);
        addToLog(QString("rxFunctions: currentMode pos:=%1").arg(syncPosition-(block)*RXSTRIPE+FILTERDELAY),DBRXFUNC);
#ifndef QT_NO_DEBUG
#ifdef RXFUNSCOPE_ENABLED
        scopeViewer->addData1(rxFilter->filteredDataPtr(),sampleCounter,RXSTRIPE);
				scopeViewer->addData2(currentMode->debugStatePtr,sampleCounter,RXSTRIPE);
        for(int m=0;m<RXSTRIPE;m++)
        {
          if(currentMode->debugStatePtr[m]>50)
           {
             addToLog("hunt1: debugStatePtr out of limits",DBRXFUNC);
            }
        }
#endif
#endif
				sndIO->rxBuffer.skip(RXSTRIPE);
				sampleCounter+=RXSTRIPE;
				while(sampleCounter<sampleCounterLatch)
					{
						sndIO->rxBuffer.copy(tempBuf,RXSTRIPE); 
						rxFilter->processFM(tempBuf);
            currentMode->process(rxFilter->filteredDataPtr());
#ifndef QT_NO_DEBUG
#ifdef RXFUNSCOPE_ENABLED
            scopeViewer->addData1(rxFilter->filteredDataPtr(),sampleCounter,RXSTRIPE);
						scopeViewer->addData2(currentMode->debugStatePtr,sampleCounter,RXSTRIPE);
            for(int m=0;m<RXSTRIPE;m++)
            {
              if(currentMode->debugStatePtr[m]>50)
               {
                 addToLog("hunt2: debugStatePtr out of limits",DBRXFUNC);
                }
            }
#endif
#endif
						sndIO->rxBuffer.skip(RXSTRIPE);
						sampleCounter+=RXSTRIPE;
					}
				currentMode->redrawFast(FALSE);
				setState(PROCESSING);
				}
			break;


			case PROCESSING:
        getData();
        mutex.lock();
        if(currentMode->process(rxFilter->filteredDataPtr())==modeBase::MBENDOFIMAGE)
          {
            setState(END);
          }
#ifndef QT_NO_DEBUG
#ifdef RXFUNSCOPE_ENABLED
        scopeViewer->addData1(rxFilter->filteredDataPtr(),sampleCounter,RXSTRIPE);
				scopeViewer->addData2(currentMode->debugStatePtr,sampleCounter,RXSTRIPE);
        for(int m=0;m<RXSTRIPE;m++)
        {
          if(currentMode->debugStatePtr[m]>50)
           {
             addToLog("proc: debugStatePtr out of limits",DBRXFUNC);
            }
        }
#endif
#endif
				sampleCounter+=RXSTRIPE;
				if((syncProc->hasNewClock())&&(rxMW->autoSlantAdjust))
					{
						setState(HUNTING);
          }
        mutex.unlock();
			break;
      case RESTART:
        addToLog("rxFunction: restart executed",DBRXFUNC);
        init();
      break;

      case SYNCLOST:

        rewindPosition=syncProc->getRewindPosition();
        block=(sampleCounter-rewindPosition)/RXSTRIPE;
        sndIO->rxBuffer.rewind(block*RXSTRIPE);
        setState(RESTART);
      break;

			case END:
        addToLog("rxFunc state END",DBRXFUNC);
        ce = new endImageRXEvent();
        ce->waitFor(&done);
        QApplication::postEvent(dispatchPtr, ce);
        while(!done) { msleep(10);}
        setState(RESTART);
			break;
      case WAIT:
        msleep(10);
      break;


		}
}


void rxFunction::setState(erxState st)
{
	addToLog(QString("rxfunc: set rxState: from %1 to %2").arg(stateStr[rxState]).arg (stateStr[st]),DBRXFUNC);
	rxState=st;
}


void rxFunction::init()
{
  addToLog(QString("rxfunc: init called from rxState: %1").arg(rxState),DBRXFUNC);
  mutex.lock();
  setFilter(rxMW->filterIndex);
  rxMode=SSTV;
  setState(HUNTING);
	currentMode=0;
	syncProc->init(modeComboBoxIndexSSTV);
	sampleCounter=0;
  mutex.unlock();
}

void rxFunction::setFilter(int fIndex)
{
  if(rxFilter==NULL)
    {
      rxFilter= new filter(RXSTRIPE,filterStruct[fIndex].filterPtr,RXNUMTAPS,filterStruct[fIndex].centerFrequency,TRUE);
    }
  else
  {
    rxFilter->setFilterParams(filterStruct[fIndex].filterPtr,RXNUMTAPS,filterStruct[fIndex].centerFrequency,TRUE);
  }
}

void rxFunction::retraceVertical(void)
{
	int rwCount;
	rwCount=(int)(((rxClock*0.3)/RXSTRIPE)+2)*RXSTRIPE; // rewind to position before the last detected retrace
  addToLog(QString("rxFunction: retraceVertical: count=%1").arg(rwCount),DBRXFUNC);
	sndIO->rxBuffer.rewind(rwCount);
	setState(RESTART);
}

void rxFunction::syncLost(void)
{
  setState(SYNCLOST);
  addToLog("rxFunction:SYNCLOST",DBRXFUNC);
}




void rxFunction::restart(void)
{
  addToLog("rxFunction: restart called",DBRXFUNC);
  setState(RESTART);
}


bool rxFunction::create(esstvMode m,DSPFLOAT clock)
{
  bool done=FALSE;
  if(currentMode) delete currentMode;
  currentMode=0;
	switch (m)
		{
			case M1:
			case M2:
				currentMode=new modeGBR(m,RXSTRIPE,FALSE);
			break;
			case S1:
			case S2:
			case SDX:
				currentMode=new modeGBR2(m,RXSTRIPE,FALSE);
			break;
			case R36:
        currentMode=new modeRobot1(m,RXSTRIPE,FALSE);
      break;
			case R24:
			case R72:
          currentMode=new modeRobot2(m,RXSTRIPE,FALSE);
    break;
			case SC2_60:
			case SC2_120:
			case SC2_180:
			case P3:
			case P5:
			case P7:
					currentMode=new modeRGB(m,RXSTRIPE,FALSE);
			break;
			case FAX480:
			case BW8:
			case BW12:
          currentMode=new modeBW(m,RXSTRIPE,FALSE);
      break;
      case AVT24:
      case AVT90:
      case AVT94:
          currentMode=new modeAVT(m,RXSTRIPE,FALSE);
      break;
			case PD50:
			case PD90:
			case PD120:
			case PD160:
			case PD180:
			case PD240:
			case PD290:
			case MP73:
			case MP115:
			case MP140:
			case MP175:
          currentMode=new modePD(m,RXSTRIPE,FALSE);
			break;
			default: 
				m=NOTVALID;
			break;
		}
	if (m!=NOTVALID)
		{
      initializeSSTVParametersIndex(m,FALSE);
			QString s=getSSTVModeNameLong(m);
      addToLog("rxFunction:create RX mode",DBRXFUNC);
 			currentMode->init(clock);
      startImageRXEvent* ce = new startImageRXEvent();
      ce->waitFor(&done);
      QApplication::postEvent(dispatchPtr, ce);
      while(!done) { msleep(10);}
      return TRUE;
		}
	return FALSE;
}


void rxFunction::runFAX()
{
}


void rxFunction::logStatus()
{

  QString stat;
  if(isRunning()) stat="TRUE"; else stat="FALSE";
  addToLog(QString("RX is running %1, Buffer Count %2").arg(stat).arg(bufferCount),DBDISPAT);
  addToLog(QString("rxState %1, currentMode %2").arg(rxState).arg(QString::number((ulong)currentMode,16)),DBDISPAT);
  if(isRunning()) syncProc->logStatus();
}

bool rxFunction::saveOK()
{
  if(currentMode==0)
  {
    addToLog("saveOK called with currentMode==0",DBRXFUNC);
    return FALSE;
  }

  if(currentMode->receivedLines()>(currentMode->imageLines()/3)) return TRUE;
  return FALSE;
}
