/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2019 Broadcom.
 */

#ifndef __GIC_V3_H__
#define __GIC_V3_H__

#ifndef __ASSEMBLY__
#include <linux/bitops.h>
#endif

#define GICR_CTLR_ENABLE_LPIS		BIT(0)
#define GICR_CTLR_RWP			BIT(3)

#define GICR_TYPER_CPU_NUMBER(r)	(((r) >> 8) & 0xffff)

#define GICR_WAKER_PROCESSORSLEEP	BIT(1)
#define GICR_WAKER_CHILDRENASLEEP	BIT(2)

#define GIC_BASER_CACHE_NCNB		0ULL
#define GIC_BASER_CACHE_SAMEASINNER	0ULL
#define GIC_BASER_CACHE_NC		1ULL
#define GIC_BASER_CACHE_RAWT		2ULL
#define GIC_BASER_CACHE_RAWB		3ULL
#define GIC_BASER_CACHE_WAWT		4ULL
#define GIC_BASER_CACHE_WAWB		5ULL
#define GIC_BASER_CACHE_RAWAWT		6ULL
#define GIC_BASER_CACHE_RAWAWB		7ULL
#define GIC_BASER_CACHE_MASK		7ULL
#define GIC_BASER_NONSHAREABLE		0ULL
#define GIC_BASER_INNERSHAREABLE	1ULL
#define GIC_BASER_OUTERSHAREABLE	2ULL
#define GIC_BASER_SHAREABILITY_MASK	3ULL

#define GIC_BASER_CACHEABILITY(reg, inner_outer, type)	\
	(GIC_BASER_CACHE_##type << reg##_##inner_outer##_CACHEABILITY_SHIFT)

#define GIC_BASER_SHAREABILITY(reg, type)	\
	(GIC_BASER_##type << reg##_SHAREABILITY_SHIFT)

/* encode a size field of width @w containing @n - 1 units */
#define GIC_ENCODE_SZ(n, w) (((unsigned long)(n) - 1) &\
			     GENMASK_ULL(((w) - 1), 0))

#define GICR_PROPBASER_SHAREABILITY_SHIFT		(10)
#define GICR_PROPBASER_INNER_CACHEABILITY_SHIFT		(7)
#define GICR_PROPBASER_OUTER_CACHEABILITY_SHIFT		(56)
#define GICR_PROPBASER_SHAREABILITY_MASK	\
	GIC_BASER_SHAREABILITY(GICR_PROPBASER, SHAREABILITY_MASK)
#define GICR_PROPBASER_INNER_CACHEABILITY_MASK	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, MASK)
#define GICR_PROPBASER_OUTER_CACHEABILITY_MASK	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, OUTER, MASK)
#define GICR_PROPBASER_CACHEABILITY_MASK GICR_PROPBASER_INNER_CACHEABILITY_MASK

#define GICR_PROPBASER_INNERSHAREABLE	\
	GIC_BASER_SHAREABILITY(GICR_PROPBASER, INNERSHAREABLE)

#define GICR_PROPBASER_NCNB	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, NCNB)
#define GICR_PROPBASER_NC	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, NC)
#define GICR_PROPBASER_RAWT	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, RAWT)
#define GICR_PROPBASER_RAWB	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, RAWB)
#define GICR_PROPBASER_WAWT	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, WAWT)
#define GICR_PROPBASER_WAWB	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, WAWB)
#define GICR_PROPBASER_RAWAWT	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, RAWAWT)
#define GICR_PROPBASER_RAWAWB	\
	GIC_BASER_CACHEABILITY(GICR_PROPBASER, INNER, RAWAWB)

#define GICR_PROPBASER_IDBITS_MASK	(0x1f)
#define GICR_PROPBASER_ADDRESS(x)	((x) & GENMASK_ULL(51, 12))
#define GICR_PENDBASER_ADDRESS(x)	((x) & GENMASK_ULL(51, 16))

#define GICR_PENDBASER_SHAREABILITY_SHIFT		(10)
#define GICR_PENDBASER_INNER_CACHEABILITY_SHIFT		(7)
#define GICR_PENDBASER_OUTER_CACHEABILITY_SHIFT		(56)
#define GICR_PENDBASER_SHAREABILITY_MASK	\
	GIC_BASER_SHAREABILITY(GICR_PENDBASER, SHAREABILITY_MASK)
#define GICR_PENDBASER_INNER_CACHEABILITY_MASK	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, MASK)
#define GICR_PENDBASER_OUTER_CACHEABILITY_MASK	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, OUTER, MASK)
#define GICR_PENDBASER_CACHEABILITY_MASK	\
	GICR_PENDBASER_INNER_CACHEABILITY_MASK

#define GICR_PENDBASER_INNERSHAREABLE	\
	GIC_BASER_SHAREABILITY(GICR_PENDBASER, INNERSHAREABLE)

#define GICR_PENDBASER_NCNB	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, NCNB)
#define GICR_PENDBASER_NC	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, NC)
#define GICR_PENDBASER_RAWT	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, RAWT)
#define GICR_PENDBASER_RAWB	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, RAWB)
#define GICR_PENDBASER_WAWT	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, WAWT)
#define GICR_PENDBASER_WAWB	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, WAWB)
#define GICR_PENDBASER_RAWAWT	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, RAWAWT)
#define GICR_PENDBASER_RAWAWB	\
	GIC_BASER_CACHEABILITY(GICR_PENDBASER, INNER, RAWAWB)

#define GICR_PENDBASER_PTZ	BIT_ULL(62)

#define ITS_MAX_LPI_NRBITS	16 /* 64K LPIs */

#define GICD_TYPER_ID_BITS(typer)	((((typer) >> 19) & 0x1f) + 1)
#define GICD_TYPER_NUM_LPIS(typer)	((((typer) >> 11) & 0x1f) + 1)
#define GICD_TYPER_IRQS(typer)		((((typer) & 0x1f) + 1) * 32)

/* Message based interrupts support */
#define GICD_TYPER_MBIS		BIT(16)
/* LPI support */
#define GICD_TYPER_LPIS		BIT(17)
#define GICD_TYPER_RSS		BIT(26)

#define GIC_REDISTRIBUTOR_OFFSET 0x20000

#ifdef CONFIG_GIC_V3_ITS
int gic_lpi_tables_init(u64 base, u32 max_redist);
#else
int gic_lpi_tables_init(u64 base, u32 max_redist)
{
	return 0;
}
#endif /* CONFIG_GIC_V3_ITS */

#endif /* __GIC_V3_H__ */
